VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DlxOCX32.ocx"
Begin VB.Form Form1 
   Caption         =   "Pulse Width Measurement with KPCI-3140"
   ClientHeight    =   9165
   ClientLeft      =   2235
   ClientTop       =   1590
   ClientWidth     =   8985
   LinkTopic       =   "Form1"
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   9165
   ScaleWidth      =   8985
   Begin VB.PictureBox Picture1 
      AutoSize        =   -1  'True
      Height          =   5520
      Left            =   360
      Picture         =   "3140pw.frx":0000
      ScaleHeight     =   5460
      ScaleWidth      =   8115
      TabIndex        =   6
      Top             =   2160
      Width           =   8175
   End
   Begin VB.TextBox txtStatus 
      Enabled         =   0   'False
      Height          =   285
      Left            =   600
      TabIndex        =   5
      Top             =   1560
      Width           =   6375
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "Exit"
      Height          =   495
      Left            =   7320
      TabIndex        =   4
      Top             =   8160
      Width           =   1095
   End
   Begin VB.TextBox Text1 
      Enabled         =   0   'False
      Height          =   495
      Left            =   2760
      TabIndex        =   1
      Top             =   840
      Width           =   1695
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Measure"
      Height          =   495
      Left            =   600
      TabIndex        =   0
      Top             =   840
      Width           =   1815
   End
   Begin DlsrLib.DriverLINXSR DriverLINXSR3 
      Left            =   6480
      Top             =   240
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin DlsrLib.DriverLINXSR DriverLINXSR2 
      Left            =   5880
      Top             =   240
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin DlsrLib.DriverLINXSR DriverLINXSR1 
      Left            =   7080
      Top             =   240
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Label Label2 
      Caption         =   " Pulse Width (msec)"
      Height          =   255
      Left            =   2760
      TabIndex        =   3
      Top             =   480
      Width           =   1695
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   " KEITHLEY "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   360
      Left            =   600
      TabIndex        =   2
      Top             =   240
      Width           =   1665
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
' this program was written in VB6
' it was tested with a KPCI-3140 board with 3140-850A02 driver version in
' Win2KSP1
Dim di As Integer

Private Sub cmdExit_Click()
' unload the driver for each SR object
DriverLINXSR1.Req_DLL_name = ""
DriverLINXSR2.Req_DLL_name = ""
DriverLINXSR3.Req_DLL_name = ""
End
End Sub

Private Sub Command1_Click()

Command1.Enabled = False
Text1.Text = ""
DoEvents
' this examplel uses counter 0 to generate a 1KHz square wave.  This signal is used
' as the timebase for the pulse width measurement channel (channel 1).  This gives only
' msec time resolution.  Generate a faster (or slower) timebase for different resolution, but
' for faster timebase, remember not to allow the 16bit counter to reach full scale before the
' pulse is complete.....
With DriverLINXSR3 'start 1 millisecond time base on counter 0
.Req_op = DL_START
.Req_mode = DL_POLLED
.Req_subsystem = DL_CT
.Evt_Tim_type = DL_RATEEVENT
.Evt_Tim_rateChannel = 0
.Evt_Tim_rateClock = DL_INTERNAL1
.Evt_Tim_rateGate = DL_DISABLED
.Evt_Tim_rateMode = DL_SQWAVE
.Evt_Tim_ratePeriod = .DLSecs2Tics(DL_INTERNAL1, 0.001)
.Refresh
End With
showmessage DriverLINXSR3

' set up bit 0 of digital port D (chan 3) to send a message for a falling edge
With DriverLINXSR2
.Req_op = DL_START
.Req_mode = DL_INTERRUPT
.Req_subsystem = DL_CT
.Evt_Str_type = DL_COMMAND
.Evt_Stp_type = DL_TCEVENT
.Evt_Tim_type = DL_DIEVENT
.Evt_Tim_diChannel = DL_DI_EXTCLK
.Evt_Tim_diMask = 2 ^ 0  ' which bit of Port D...1 through 8
.Evt_Tim_diMatch = DL_NotEquals
.Evt_Tim_diPattern = 1 * .Evt_Tim_diMask ' 0 for rising edge, 1 for falling edge
'No channel list or buffers => receive TimerTic events
.Refresh
End With

' start the pulse width measurement task
With DriverLINXSR1
.Req_op = DL_START
.Req_mode = DL_POLLED
.Req_subsystem = DL_CT
.Evt_Tim_type = DL_RATEEVENT
.Evt_Tim_rateChannel = 1
.Evt_Tim_rateClock = DL_TCNm1   'Use internal cascade from the output of counter 0 as clock source
.Evt_Tim_rateGate = HILEVELGATEN   ' Active High gate
.Evt_Tim_rateMode = DL_PULSEWD     ' Pulse Width mode
.Evt_Tim_ratePulses = 1
.Evt_Tim_rateOnCount = 0
.Evt_Tim_ratePeriod = 0
.Refresh
End With
showmessage DriverLINXSR1

txtStatus.Text = "Pulse Width Measurement task is now armed.....waiting for active high pulse"


End Sub


Private Sub DriverLINXSR2_TimerTic(task As Integer, device As Integer, subsystem As Integer, mode As Integer)
' DriverLINXSR2 was used to detect falling edges at port D
'
' if we are here, it must be time to read the counter....
With DriverLINXSR1 'read counter
.Req_op = DL_STATUS
.Refresh
Text1.Text = .Res_Tim_count
.Req_op = DL_STOP
.Refresh
End With
With DriverLINXSR2  ' dont allow sensitivity to other falling edges
.Req_op = DL_STOP
.Refresh
End With
With DriverLINXSR3 'stop the square wave source
.Req_op = DL_STOP
.Refresh
End With
txtStatus.Text = "The measurement is complete."
Command1.Enabled = True
End Sub

Private Sub Form_Load()
With DriverLINXSR1   ' used to do a pulse width measurement
.Req_DLL_name = "kpci3140$"  ' load only kpci3140 driver
.Req_device = 0
.Req_subsystem = DL_DEVICE
.Req_mode = DL_OTHER
.Req_op = DL_INITIALIZE
.Refresh
End With
showmessage DriverLINXSR1
With DriverLINXSR2 ' used to detect falling edges with bit 0 of digital channel 3 (Port D)
.Req_DLL_name = DriverLINXSR1.Req_DLL_name
.Req_device = DriverLINXSR1.Req_device
End With
showmessage DriverLINXSR2
With DriverLINXSR3  ' used to generate a 1KHz timebase signal with CT channel 0
.Req_DLL_name = DriverLINXSR2.Req_DLL_name
.Req_device = DriverLINXSR2.Req_device
End With

End Sub


Sub showmessage(sr As Control)
sr.Req_op = DL_MESSAGEBOX
sr.Refresh
End Sub
